#include <iostream>
#include <cstdio>
#include <vector>
#include <cstdlib>
#include <cstring>
using namespace std;

const int mod = 1e9 + 7;


int dp[2005][2005];
int fact[2005], rfact[2005];
int nfact[2005];

void add(int &a, int b)
{
	a = (a + b) % mod;
}
void sub(int &a, int b)
{
	a = (a - b + mod) % mod;
}

void mul(int &a, int b)
{
	a = (a * 1LL * b) % mod; 
}

int fpow(int x, int n)
{
	if (n == 0)
		return 1;
	int a = fpow(x, n >> 1);
	mul(a, a);
	if (n & 1)
		mul(a, x);
	return a;
}

int getC(int k)
{
	int ans = nfact[k];
	mul(ans, rfact[k] );
	return ans;
}

int getAns(int n, int x)
{
	int ans = 0;
	for (int k = 1; k <= n; k++)
	{
		int curans = getC(k);
		mul(curans, dp[k][n] );
		add(ans, curans);
	}
	return ans;
}

int getRev(int x)
{
	return fpow(x, mod - 2);
}

void calcFact(int n, long long d)
{
	fact[0] = 1;
	for (int i = 1; i <= n; i++)
	{
		fact[i] = i;
		mul(fact[i], fact[i - 1] );
	}
	for (int i = 0; i <= n; i++)
		rfact[i] = getRev(fact[i] );
	nfact[0] = 1;
	for (int i = 1; i <= n; i++)
	{
		nfact[i] = (d - i + 1) % mod;
		mul(nfact[i], nfact[i - 1] );
	}

}

void calcDp(int n, int x)
{
	for (int i = 0;  i <= n; i++)
		for (int j = 0; j <= n; j++)
			dp[i][j] = 0;
	dp[0][0] = 1;
	for (int i = 0; i < n; i++)
	{
		for (int j = 0; j <= n; j++)
		{
			add(dp[i + 1][j + 1], dp[i][j] );
			if (j + x <= n)
				sub(dp[i + 1][j + x], dp[i][j] );
		}
		for (int j = 0; j < n; j++)
		{
			add(dp[i + 1][j + 1], dp[i + 1][j] );
		}
	}	
}


bool solve()
{
	int n;
	long long d;
	int x;
	scanf("%d%lld%d", &n, &d, &x);
	if (n == 0)
		return false;
	calcDp(n, x);
	calcFact(n, d);
	int ans = getAns(n, x);
	printf("%d\n", ans);
	return true;
}

int main()
{
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);


	while (solve() ) {}

	return 0;
}